% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findClusterAuto.R
\name{findClusterAuto}
\alias{findClusterAuto}
\title{Automaticly Find Clusters}
\usage{
findClusterAuto(x, mycols = NULL, nclust = 2, ac = 1, f.cut = c(0.1,
  0.2, 0.3), verbose = FALSE, findSil = TRUE)
}
\arguments{
\item{x}{a list. Return value from findRd(). The list contains "f", "delta",
"dat", and "distm".}

\item{mycols}{a vector of character string. Colors to be used to distinguish.
different cluster.}

\item{nclust}{a number. Number of clusters.}

\item{ac}{an integer indicating which automatic cut method is used. Currently take two values:
\itemize{
\item{ac = 1: }{in the f vs. delta decision plot, 'nclust' points with f > percentile f.cut and nclust largest delta's are declaired centroids.}
\item{ac = 2: }{in the f vs. delta decision plot, denote by l the diagonal line connecting the point with smallest f and largest delta, and the point with largest f and smallest delta. 'nclust' points that are above l, and have are farthest away from l are declared centroids.}
}}

\item{f.cut}{numeric vector. f.cut is used in variation = "auto" to automatically select cluster centroids from the decision plot. Points with f(x) > f.cut and high delta(x) are selected as candidate centroids. 
#'}

\item{verbose}{if TRUE progress will be displayed.}

\item{findSil}{if FALSE silhouette score is NOT calculated, and the field that stores silhouette is set to -Inf. The default is TRUE. This argument is IGNORED if length(h) == 0 or length(h) > 1 or length(nclust) > 1, as silhouette scores are needed to select the best clustering in these cases.#'}
}
\value{
a list of the following items:
\itemize{
\item rho: vector of rho's.
\item delta: vector of delta's.
\item icenter: indices of cluster centers.
\item clusters: integer string recording cluster assignments. 
\item score: silouette of the clustering result.
\item h: bandwith h.
}
}
\description{
This function uses rho and delta (calculated from findRd()) to
automaticly find clusters.
}
\details{
centers of clusters are selected as follows. Points corresponding to the largest nclust delta values are selected from
the points whose rho's are greater than 10th percentile.
}
\examples{
## To be finished
}

