% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMPSDAnalyser.R
\docType{methods}
\name{RoughnessByLengthScale}
\alias{RoughnessByLengthScale}
\alias{RoughnessByLengthScale,AFMImage-method}
\title{Calculate the roughness of the sample against length scale}
\usage{
RoughnessByLengthScale(AFMImage, AFMImagePSDAnalysis)

\S4method{RoughnessByLengthScale}{AFMImage}(AFMImage, AFMImagePSDAnalysis)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{AFMImagePSDAnalysis}{n \code{AFMImagePSDAnalysis} to store the setup and results of PSD analysis}
}
\value{
a data table of lenght scale (r) and roughness values (roughness)
\itemize{ 
\item {roughness: roughnesses} 
\item {r: length scales}
\item {filename: fullfilename slot of the AFMImage} 
}
}
\description{
The calculation of the roughness against lengthscale is performed throught a FFT 2D calculation, PSD 2D calculation and a meshgrid of frequencies.
\code{RoughnessByLengthScale} returns a data.table of roughnesses against length scales
}
\examples{
library(AFM)
library(ggplot2)

data("AFMImageOfNormallyDistributedHeights")
oneAFMImage<-AFMImageOfNormallyDistributedHeights
AFMImagePSDAnalysis<-AFMImagePSDAnalysis()
data<-RoughnessByLengthScale(oneAFMImage, AFMImagePSDAnalysis)
r<-roughness<-filename<-NULL
p1 <- ggplot(data, aes(x=r, y=roughness, colour= basename(filename)))
p1 <- p1 + geom_point()
p1 <- p1 + geom_line()
p1 <- p1 + ylab("roughness (nm)")
p1 <- p1 + xlab("lengthscale (nm)")
p1
}
\author{
M.Beauvais
}

