% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImage.R
\name{saveOnDisk}
\alias{saveOnDisk}
\title{Save an AFM image on disk.}
\usage{
saveOnDisk(AFMImage, exportDirectory)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{exportDirectory}{an optional argument to change the directory where the rdata file will be stored on disk}
}
\description{
The function saves the an \code{\link{AFMImage}} as a rdata file. It uses the fullfilename param of the \code{\link{AFMImage}} and add "AFMImage.rda" extension to save the rdata file on disk.
}
\details{
\code{saveOnDisk} save on disk an \code{\link{AFMImage}} as rdata file
}
\examples{
library(AFM)

data(AFMImageOfAluminiumInterface)
# save the rdata file of the AFMImage in the tempdir() directory;
# select another directory to save it permanently on your hard drive
saveOnDisk(AFMImageOfAluminiumInterface, tempdir())

}
\author{
M.Beauvais
}

