% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apis_functions.R
\name{mml}
\alias{mml}
\title{MML estimator}
\usage{
mml(Rho, ff, dataset, wmat, var.agg, m = 10)
}
\arguments{
\item{Rho}{the constrained parameter of spatial dependence}

\item{ff}{Formula of the linear model. It excludes the spatial lag}

\item{dataset}{Data frame with the data}

\item{wmat}{Spatial weight matrix}

\item{var.agg}{Spatial index of the data frame}

\item{m}{How many time periods have passed since the beginning of the space-time process}
}
\value{
The estimates tables
}
\description{
This function estimates a space time linear model according to the specified formula using the ML estimator as in Elhorst (2010) \doi{10.1016/j.regsciurbeco.2010.03.003}. The estimator maximizes the full log-likelihood function in which the parameter of spatial dependence is constrained.
}
\examples{
\donttest{
library(rgdal)
set.seed(123)
sd = sim_data_fe(dataset=regsamp,N=50,TT=6,
                spatial = 80,Tau = -0.2,Rho = 0.4,
                Beta = 2,sdDev = 2,startingT = 10,
                LONGLAT = TRUE);sd[[1]]$X2 = stats::rnorm(nrow(sd[[1]]@data))
est_mml = mml(dataset = sd[[1]]@data,Rho = 0.4,
              ff = Y~X1+X2,
              wmat = sd[[2]],var.agg = c('Anno','Cod_Provincia'),
              m = 10)
est_mml
}

}
