% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\docType{class}
\name{aniso_simulation-class}
\alias{aniso_simulation-class}
\title{Anisotropic simulation class}
\description{
S4 class for anisotropic 2D particle movement simulation.
}
\details{
\code{intensity} should has structure 'T_SS_mat', matrix with dimension
\code{len_t} by \code{sz}\eqn{\times}{\%\times}\code{sz}.

\code{pos} should be the position matrix with dimension
\code{M}\eqn{\times}{\%\times}\code{len_t}. See \code{\link{bm_particle_intensity}},
\code{\link{ou_particle_intensity}}, \code{\link{fbm_particle_intensity}},
\code{\link{fbm_ou_particle_intensity}}.
}
\section{Slots}{

\describe{
\item{\code{sz}}{vector. Frame size of the intensity profile, number of pixels
contained in each frame equals \code{sz[1]} by \code{sz[2]}.}

\item{\code{len_t}}{integer. Number of time steps.}

\item{\code{noise}}{character. Background noise, options from ('uniform','gaussian').}

\item{\code{model_name}}{character. Simulated stochastic process, options from ('BM','OU','FBM','OU+FBM').}

\item{\code{M}}{integer. Number of particles.}

\item{\code{pxsz}}{numeric.  Size of one pixel in unit of micron, 1 for simulated data.}

\item{\code{mindt}}{numeric. Minimum lag time, 1 for simulated data.}

\item{\code{pos}}{matrix. Position matrix for particle trajectory, see 'Details'.}

\item{\code{intensity}}{matrix. Filled intensity profile, see 'Details'.}

\item{\code{num_msd}}{matrix. Numerical mean squared displacement (MSD).}

\item{\code{param}}{matrix. Parameters used to construct MSD.}

\item{\code{theor_msd}}{matrix. Theoretical MSD.}

\item{\code{sigma_2_0}}{vector. Variance of background noise.}
}}

\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{classes}
