% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_MSD_with_grad}
\alias{get_MSD_with_grad}
\title{Construct MSD and MSD gradient with transformed parameters}
\usage{
get_MSD_with_grad(theta, d_input, model_name, msd_fn = NA, msd_grad_fn = NA)
}
\arguments{
\item{theta}{transformed parameters in MSD function for MLE estimation}

\item{d_input}{sequence of lag times}

\item{model_name}{model name for the process, options from  ('BM','OU','FBM',
'OU+FBM', 'user_defined').}

\item{msd_fn}{user defined MSD structure, a function of \code{theta} and \code{d_input}}

\item{msd_grad_fn}{user defined MSD gradient structure,  a function of
\code{theta} and \code{d_input}}
}
\value{
A list of two variables, MSD and MSD gradient.
}
\description{
Construct mean squared displacement (MSD) and its gradient for a given
stochastic process or a user defined MSD and gradient structure.
}
\details{
Note for non \code{user_defined} model, \code{msd_fn} and \code{msd_grad_fn}
are not needed. For Brownian Motion, the MSD follows
\deqn{MSD_{BM}(\Delta t) = \theta_1\Delta t= 4D\Delta t}{\%MSD_{BM}(\Delta t) = \theta_1\Delta t= 4D\Delta t}
where \code{D} is the diffusion coefficient.

For Ornstein–Uhlenbeck process,  the MSD follows
\deqn{MSD_{OU}(\Delta t) = \theta_2(1-\frac{\theta_1}{1+\theta_1}^{\Delta t})}{\%MSD_{OU}(\Delta t) = \theta_2(1-\frac{\theta_1}{1+\theta_1}^{\Delta t})}
where \eqn{\frac{\theta_1}{1+\theta_1}=\rho}{\%\frac{\theta_1}{1+\theta_1}=\rho}
is the correlation with previous steps.

For fractional Brownian Motion,  the MSD follows
\deqn{MSD_{FBM}(\Delta t) =\theta_1\Delta t^{\frac{2\theta_2}{1+\theta_2}}}{\%MSD_{FBM}(\Delta t) =\theta_1\Delta t^{\frac{2\theta_2}{1+\theta_2}}}
where \eqn{\frac{2\theta_2}{1+\theta_2}=2H}{\%\frac{2\theta_2}{1+\theta_2}=2H}
with \code{H} is the the Hurst parameter.

For 'OU+FBM', the MSD follows
\deqn{MSD_{OU+FBM}(\Delta t) = \theta_2(1-\frac{\theta_1}{1+\theta_1}^{\Delta t})+\theta_3\Delta t^{\frac{2\theta_4}{1+\theta_4}}}{\%MSD_{OU+FBM}(\Delta t) = \theta_2(1-\frac{\theta_1}{1+\theta_1}^{\Delta t})+\theta_3\Delta t^{\frac{2\theta_4}{1+\theta_4}}}
}
\examples{
library(AIUQ)
msd_fn <- function(param, d_input){
  beta = 2*param[1]^2
  MSD = beta*d_input
}
msd_grad_fn <- function(param, d_input){
  MSD_grad = 4*param[1]*d_input
}

theta = 2
d_input = 0:10
model_name = "user_defined"

MSD_list = get_MSD_with_grad(theta=theta,d_input=d_input,
                             model_name=model_name,msd_fn=msd_fn,
                             msd_grad_fn=msd_grad_fn)
MSD_list$msd
MSD_list$msd_grad

}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
