% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_isf}
\alias{get_isf}
\title{Compute empirical intermediate scattering function}
\usage{
get_isf(object, index_q = NA)
}
\arguments{
\item{object}{an S4 object of class \code{SAM}}

\item{index_q}{wavevector range used for computing ISF}
}
\value{
A matrix of empirical intermediate scattering function with dimension
\code{len_q} by \code{len_t-1}.
}
\description{
Compute empirical intermediate scattering function (ISF) using object of
\code{SAM} class.
}
\examples{
library(AIUQ)
sim_bm = simulation(len_t=100,sz=100,sigma_bm=0.5)
show(sim_bm)
sam = SAM(sim_object = sim_bm)
show(sam)
ISF = get_isf(object=sam)
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
