% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMCcreatetest.R
\name{AMCcreatetest}
\alias{AMCcreatetest}
\title{Create a full \href{http://home.gna.org/auto-qcm/index.en}{Auto-Multiple-Choice} test with a main .tex file (\code{groups.tex}), a file for questions (\code{questions.tex}), a file for elements (\code{elements.tex}.}
\usage{
AMCcreatetest(..., title = "Test", filepath = "groups.tex", messages = T,
  fontsize = 10, instructions = T, paper = "letter",
  identifier = "Name", separateanswersheet = F,
  answersheettitle = "Answer sheet", answersheetinstructions = T,
  twosided = T, box = T)
}
\arguments{
\item{...}{Arguments passed to \code{AMCcreatequestions()} (see documentation).}

\item{title}{A character value indicating a title for the test (default is "Test").}

\item{filepath}{A character value indicating the path for the main .tex file output (most often, in AMC, it is \code{groups.tex}, which is the default of the function). Note that the other created files (\code{questions.tex} and \code{elements.tex} will we written in the folder of this file).}

\item{messages}{A logical value to indicate whether to output messages and reports (default is TRUE).}

\item{fontsize}{A numeric value to indicate the font size of the output document. Default is 10. Note: Above 12 pt, the LaTeX package "extarticle" is automatically used in lieu of "article".}

\item{instructions}{A logical value to add a block of preliminary instructions to the students (for example, how to fill the questionnaire). Defaults to TRUE.}

\item{paper}{A character value indicating what type of paper to use. Default is "letter", but "a4" can also be used.}

\item{identifier}{A character value indicating what to ask for to pair the exam sheets. The default is "Name", but other values like "Student ID Number" may be more appropriate.}

\item{separateanswersheet}{A logical value to indicate whether to use a separate answer sheet. Defaults to FALSE.}

\item{answersheettitle}{A character value to indicate the title of the separate answer sheet. Defaults to "Answer sheet".}

\item{answersheetinstructions}{A logical or character value to add default (TRUE), remove (FALSE) or customize (character value) instructions given on the separate answer sheet. Default is TRUE, which indicates that the students shall answer on the answer sheet.}

\item{twosided}{A logical value to indicate whether the exam will be printed two sided. This is notably important when printing on a separate answer sheet, to have the answer sheet printed on a separate page. Defaults to TRUE.}

\item{box}{A logical value to indicate whether to box the questions and answers, to ensure that they are always presented on the same page. Defaults to TRUE.}
}
\value{
Writes 3 tex documents (\code{groups.tex}, \code{questions.tex} and \code{elements.tex})) for direct use in \href{http://home.gna.org/auto-qcm/index.en}{Auto-Multiple-Choice}.
}
\description{
Create a full \href{http://home.gna.org/auto-qcm/index.en}{Auto-Multiple-Choice} test with a main .tex file (\code{groups.tex}), a file for questions (\code{questions.tex}), a file for elements (\code{elements.tex}.
}
\examples{
# Create all LaTeX files

\dontrun{
 AMCcreatetest(
 # Part passed to AMCcreatequestions() (see documentation)
 "How much is $1+2$?",2,list("3", "11"),
 # Part used for test options
 title = "This is the title", #Custom title
 paper = "a4", #change the paper for a4
 fontsize = 11, #change fontsize
 identifier = "ID Number", #change identifier
 twosided = F, #print in one sided
 instructions = T, #show an instructions block to students
 separateanswersheet = T, #use a separate answer sheet
 answersheettitle = "Respond Here", #Change answer sheet title
 answersheetinstructions = "Fill the boxes" #Answer sheet instructions
  )}

}
