\encoding{latin1}
\name{train}
\alias{train}

\title{Neural network training function.}

\description{For a given data set (training set), this function modifies the neural network weights and biases to approximate the relationships amongst variables present in the training set. These may serve to satisfy several needs, i.e. fitting non-linear functions.}

\usage{
train(net,P,T,n.epochs,g=adapt.NeuralNet, error.criterium="MSE", Stao=NA, report=TRUE, show.step)
}

\arguments{
\item{net}{Neural Network to train.}
\item{P}{Training set input values.}
\item{T}{Training set output values}
\item{n.epochs}{Number of epochs to train.}
\item{g}{Adaptative function used for training. The default provides a quicker C code version of the adaptative backpropagation with momentum method.}
\item{error.criterium}{Criterium used to measure the goodness of fit.}
\item{Stao}{Initial value of the S parameter used by the TAO algorithm.}
\item{report}{Logical value indicating whether the training function should keep quiet or should provide graphical/written information during the training process instead.}
\item{show.step}{If report is TRUE then a report is provided every show.step epochs.}
}

\value{This function returns a trained Neural Network object with weights and biases adjusted by the adaptative backpropagation with momentum method. The whole training set is considered.}
\author{
Manuel Castejn Limas. 	            \email{manuel.castejon@unileon.es}\cr
Joaquin Ordieres Mer.	            \email{joaquin.ordieres@dim.unirioja.es}\cr
Ana Gonzlez Marcos.                \email{ana.gonzalez@unileon.es} \cr
Alpha V. Perna Espinoza.           \email{alpha.pernia@alum.unirioja.es}\cr
Eliseo P. Vergara Gonzalez.         \email{eliseo.vergara@dim.unirioja.es}\cr
Francisco Javier Martinez de Pisn. \email{francisco.martinez@dim.unirioja.es}\cr
Fernando Alba Elas.                \email{fernando.alba@unavarra.es}\cr
}

\references{
Pernia Espinoza, A.V. TAO-ROBUST BACKPROPAGATION LEARNING ALGORITHM  \cr \cr
Simon Haykin. Neural Networks. A comprehensive foundation. 2nd Edition. \cr \cr
}

\seealso{
\code{\link{train.compare}}, \code{\link{adapt.R.NeuralNet}}, \code{\link{backpropagate.adapt.R.NeuralNet}} 
}

\keyword{neural}

