% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atc.R
\name{atc_property}
\alias{atc_property}
\title{Properties of an ATC code}
\source{
\url{https://www.whocc.no/atc_ddd_alterations__cumulative/ddd_alterations/abbrevations/}
}
\usage{
atc_property(atc_code, property, administration = "O",
  url = "https://www.whocc.no/atc_ddd_index/?code=\%s&showdescription=no")
}
\arguments{
\item{atc_code}{a character or character vector with ATC code(s) of antibiotic(s)}

\item{property}{property of an ATC code. Valid values are \code{"ATC code"}, \code{"Name"}, \code{"DDD"}, \code{"U"} (\code{"unit"}), \code{"Adm.R"} en \code{"Note"}.}

\item{administration}{type of administration, see \emph{Details}}

\item{url}{url of website of the WHO. The sign \code{\%s} can be used as a placeholder for ATC codes.}
}
\description{
Gets data from the WHO to determine properties of an ATC (e.g. an antibiotic) like name, defined daily dose (DDD) or standard unit. \strong{This function requires an internet connection.}
}
\details{
Abbreviations for the property \code{"Adm.R"} (parameter \code{administration}):
\itemize{
  \item{\code{"Implant"}}{ = Implant}
  \item{\code{"Inhal"}}{ = Inhalation}
  \item{\code{"Instill"}}{ = Instillation}
  \item{\code{"N"}}{ = nasal}
  \item{\code{"O"}}{ = oral}
  \item{\code{"P"}}{ = parenteral}
  \item{\code{"R"}}{ = rectal}
  \item{\code{"SL"}}{ = sublingual/buccal}
  \item{\code{"TD"}}{ = transdermal}
  \item{\code{"V"}}{ = vaginal}
}

Abbreviations for the property \code{"U"} (unit):
\itemize{
  \item{\code{"g"}}{ = gram}
  \item{\code{"mg"}}{ = milligram}
  \item{\code{"mcg"}}{ = microgram}
  \item{\code{"U"}}{ = unit}
  \item{\code{"TU"}}{ = thousand units}
  \item{\code{"MU"}}{ = million units}
  \item{\code{"mmol"}}{ = millimole}
  \item{\code{"ml"}}{ = milliliter (e.g. eyedrops)}
}
}
\examples{
\donttest{
atc_property("J01CA04", "DDD", "O") # oral DDD (Defined Daily Dose) of amoxicillin
atc_property("J01CA04", "DDD", "P") # parenteral DDD (Defined Daily Dose) of amoxicillin
}
}
