# ==================================================================== #
# TITLE                                                                #
# Antimicrobial Resistance (AMR) Analysis                              #
#                                                                      #
# SOURCE                                                               #
# https://gitlab.com/msberends/AMR                                     #
#                                                                      #
# LICENCE                                                              #
# (c) 2019 Berends MS (m.s.berends@umcg.nl), Luz CF (c.f.luz@umcg.nl)  #
#                                                                      #
# This R package is free software; you can freely use and distribute   #
# it for both personal and commercial purposes under the terms of the  #
# GNU General Public License version 2.0 (GNU GPL-2), as published by  #
# the Free Software Foundation.                                        #
#                                                                      #
# This R package was created for academic research and was publicly    #
# released in the hope that it will be useful, but it comes WITHOUT    #
# ANY WARRANTY OR LIABILITY.                                           #
# Visit our website for more info: https://msberends.gitab.io/AMR.     #
# ==================================================================== #

context("skewness.R")

test_that("skewness works", {
  expect_equal(skewness(septic_patients$age),
               -0.8958019,
               tolerance = 0.00001)
  expect_equal(unname(skewness(data.frame(septic_patients$age))),
               -0.8958019,
               tolerance = 0.00001)
  expect_equal(skewness(matrix(septic_patients$age)),
               -0.8958019,
               tolerance = 0.00001)
})
