% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{intrinsic_resistant}
\alias{intrinsic_resistant}
\title{Data Set with Bacterial Intrinsic Resistance}
\format{
A \link[tibble:tibble]{tibble} with 134 634 observations and 2 variables:
\itemize{
\item \code{mo}\cr Microorganism ID
\item \code{ab}\cr Antibiotic ID
}
}
\usage{
intrinsic_resistant
}
\description{
Data set containing defined intrinsic resistance by EUCAST of all bug-drug combinations.
}
\details{
This data set is based on \href{https://www.eucast.org/expert_rules_and_expected_phenotypes}{'EUCAST Expert Rules' and 'EUCAST Intrinsic Resistance and Unusual Phenotypes' v3.3} (2021).
\subsection{Direct download}{

Like all data sets in this package, this data set is publicly available for download in the following formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, SAS, and Stata. Please visit \href{https://msberends.github.io/AMR/articles/datasets.html}{our website for the download links}. The actual files are of course available on \href{https://github.com/msberends/AMR/tree/main/data-raw}{our GitHub repository}.

They \strong{allow for machine reading EUCAST and CLSI guidelines}, which is almost impossible with the MS Excel and PDF files distributed by EUCAST and CLSI.
}
}
\examples{
intrinsic_resistant
}
\keyword{datasets}
