% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{WHONET}
\alias{WHONET}
\title{Data Set with 500 Isolates - WHONET Example}
\format{
A \link[tibble:tibble]{tibble} with 500 observations and 53 variables:
\itemize{
\item \verb{Identification number}\cr ID of the sample
\item \verb{Specimen number}\cr ID of the specimen
\item \code{Organism}\cr Name of the microorganism. Before analysis, you should transform this to a valid microbial class, using \code{\link[=as.mo]{as.mo()}}.
\item \code{Country}\cr Country of origin
\item \code{Laboratory}\cr Name of laboratory
\item \verb{Last name}\cr Fictitious last name of patient
\item \verb{First name}\cr Fictitious initial of patient
\item \code{Sex}\cr Fictitious gender of patient
\item \code{Age}\cr Fictitious age of patient
\item \verb{Age category}\cr Age group, can also be looked up using \code{\link[=age_groups]{age_groups()}}
\item \verb{Date of admission}\cr \link{Date} of hospital admission
\item \verb{Specimen date}\cr \link{Date} when specimen was received at laboratory
\item \verb{Specimen type}\cr Specimen type or group
\item \verb{Specimen type (Numeric)}\cr Translation of \code{"Specimen type"}
\item \code{Reason}\cr Reason of request with Differential Diagnosis
\item \verb{Isolate number}\cr ID of isolate
\item \verb{Organism type}\cr Type of microorganism, can also be looked up using \code{\link[=mo_type]{mo_type()}}
\item \code{Serotype}\cr Serotype of microorganism
\item \code{Beta-lactamase}\cr Microorganism produces beta-lactamase?
\item \code{ESBL}\cr Microorganism produces extended spectrum beta-lactamase?
\item \code{Carbapenemase}\cr Microorganism produces carbapenemase?
\item \verb{MRSA screening test}\cr Microorganism is possible MRSA?
\item \verb{Inducible clindamycin resistance}\cr Clindamycin can be induced?
\item \code{Comment}\cr Other comments
\item \verb{Date of data entry}\cr \link{Date} this data was entered in WHONET
\item \code{AMP_ND10:CIP_EE}\cr 28 different antimicrobials. You can lookup the abbreviations in the \link{antimicrobials} data set, or use e.g. \code{\link[=ab_name]{ab_name("AMP")}} to get the official name immediately. Before analysis, you should transform this to a valid antimicrobial class, using \code{\link[=as.sir]{as.sir()}}.
}
}
\usage{
WHONET
}
\description{
This example data set has the exact same structure as an export file from WHONET. Such files can be used with this package, as this example data set shows. The antimicrobial results are from our \link{example_isolates} data set. All patient names were created using online surname generators and are only in place for practice purposes.
}
\section{Download Our Reference Data}{

All reference data sets in the AMR package - including information on microorganisms, antimicrobials, and clinical breakpoints - are freely available for download in multiple formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, and Stata.

For maximum compatibility, we also provide machine-readable, tab-separated plain text files suitable for use in any software, including laboratory information systems.

Visit \href{https://amr-for-r.org/articles/datasets.html}{our website for direct download links}, or explore the actual files in \href{https://github.com/msberends/AMR/tree/main/data-raw/datasets}{our GitHub repository}.
}

\examples{
WHONET
}
\keyword{datasets}
