% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-anofa.R
\name{anofa}
\alias{anofa}
\title{anofa: analysis of frequency data.}
\usage{
anofa(formula = NULL, data = NULL, factors = NULL)
}
\arguments{
\item{formula}{A formula with the factors on the left-hand side. See below for writing the
formula according to the data format.}

\item{data}{Dataframe in one of wide, long, raw or compiled format;}

\item{factors}{For raw data formats, provide the factor names.}
}
\value{
a model fit to the given frequencies. The model must always be an omnibus model
(for decomposition of the main model, follow the analysis with \code{emFrequencies()}
or \code{contrastFrequencies()})
}
\description{
The function \code{anofa()} performs an anofa of frequencies for designs with up to 4 factors
according to the \code{anofa} framework. See \insertCite{lc23b}{ANOFA} for more.
}
\details{
The data can be given in four formats:
\itemize{
\item \code{wide}: In the wide format, there is one line for each participant, and
one column for each factor in the design. In the column(s), the level must
of the factor is given (as a number, a string, or a factor).
\item \code{long}: In the long format, there is an identifier column for each participant,
a factor column and a level number for that factor. If there are n participants
and m factors, there will be in total n x m lines.
\item \code{raw}: In the raw column, there are as many lines as participants, and as many columns as
there are levels for each factors. Each cell is a 0|1 entry.
\item \code{compiled}: In the compiled format, there are as many lines as there are cells in the
design. If there are two factors, with two levels each, there will be 4 lines.
See the vignette \code{DataFormatsForFrequencies} for more on data format and how to write their formula.
}
}
\examples{
# Basic example using a single-factor design with the data in compiled format. 
# Ficticious data present frequency of observation classified according
# to Intensity (three levels) and Pitch (two levels) for 6 possible cells.
minimalExample

formula <- Frequency ~ Intensity * Pitch
w <- anofa(formula, minimalExample) 
summary(w)

# To know more about other ways to format the datasets, 
# see, e.g., `toRaw()`, `toLong()`, `toWide()`
w <- anofa(formula, minimalExample)
toWide(w)
# See the vignette `DataFormatsForFrequencies` for more.

# Real-data example using a two-factor design with the data in compiled format:
LandisBarrettGalvin2013

w <- anofa( obsfreq ~ program * provider, LandisBarrettGalvin2013 )
summary(w)

# You can ask easier outputs
w <- anofa(formula, minimalExample)
summarize(w) # or summary(w) for the ANOFA table
explain(w)   # human-readable ouptut

}
\references{
\insertAllCited{}
}
