% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.tauKr.R
\name{stat.tauKr}
\alias{stat.tauKr}
\title{Matrix TauKr correlations}
\usage{
stat.tauKr(X, Y, Z = NULL, nperm = NULL, omitDiag)
}
\arguments{
\item{X}{a square matrix of individual interactions or associations}

\item{Y}{a square matrix of individual interactions or associations}

\item{Z}{a square matrix of individual interactions or attributes to use as a control in the matrix correlation between X and Y  (only for partial correlation)}

\item{nperm}{an integer indicating the number of permutations wanted.}

\item{omitDiag}{boolean to omit or not the diagonals in the matrices if \emph{TRUE} it does not consider diagonals}
}
\value{
a list of matrices .
}
\description{
Matrix TauKr correlation. Partial or not, with significant test or not.
}
\details{
returns a list of matrices in the same order as is the original folder.
}
\references{
Hemelrijk, C. K. 1990. Models of, and tests for, reciprocity, unidirectional and other social interaction patterns at a group level. Animal Behavior, 39, 1013-1029

Hemelrijk, C. K. 1990. A matrix partial correlation test used in investigations of reciprocity and other social interaction patterns at a group level. Journal of theoretical Biology, 143, 405-420.
}
\author{
Ivan Puga-Gonzalez, Sebastian Sosa.
}
