% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APIS_functions.R
\name{assignmentFortran}
\alias{assignmentFortran}
\title{Assignment function to obtain the average Mendelian transmission probabilities using a Fortran library}
\usage{
assignmentFortran(offspring, sire, dam, thresh = ncol(offspring),
  preselect.Parent = FALSE, nb.cores = 2, verbose = TRUE)
}
\arguments{
\item{offspring}{Offspring genotypes | Matrix (n*p) where n = number of individuals, p = number of markers
rownames(offspring) = labels of offspring
marker coding = "All1/All2" example: "A/A", "A/B", "NA/NA" (for missing genotype)}

\item{sire}{Sire genotypes | Matrix (n*p) where n = number of individuals, p = number of markers
rownames(sire) = labels of sires
marker coding = "All1/All2" example: "A/A", "A/B", "NA/NA" (for missing genotype)}

\item{dam}{Dam genotypes | Matrix (n*p) where n = number of individuals, p = number of markers
rownames(dam) = labels of dams
marker coding = "All1/All2" example: "A/A", "A/B", "NA/NA" (for missing genotype)}

\item{thresh}{(default: ncol(offspring) Threshold for exclusion (number of mismatches allowed)}

\item{preselect.Parent}{(default: FALSE) Preselection of parents. Can be FALSE, an integer or a vector of two integers (number of sires, numbers of dams)}

\item{nb.cores}{(default: 2) Number of cores to use. If you have more than 2 cores, you can use the "parallel" function detectCores()}

\item{verbose}{(default : TRUE) Display the process of the function on the console.}
}
\value{
intermidiate pedigree

log file for Mendelian transmission probabilities

log file for exclusion
}
\description{
This function calculates the average Mendelian transmission probabilities
}
\examples{
data("APIS_offspring")
data("APIS_sire")
data("APIS_dam")

assignment <- assignmentFortran(APIS_offspring[1:50, ], APIS_sire, APIS_dam, verbose = FALSE)

}
\keyword{assignment}
