% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.breaks.R
\name{find.breaks}
\alias{find.breaks}
\alias{findBreakPoints}
\alias{textBreakSegments}
\alias{testBreakPoints}
\title{find and test break-points}
\usage{
findBreakPoints(data, pollutant, h = 0.15, ...)

testBreakPoints(data, pollutant, breaks, ...)
}
\arguments{
\item{data}{Data source, typically a \code{data.frame}
or similar, containing data-series to apply function to
and a paired time-stamped data-series, called \code{date}.}

\item{pollutant}{Name of time-series, assumed to be
a column in \code{date}.}

\item{h}{(\code{findBreakPoints} only) The data/time window
size to use when looking for breaks in a supplied time-series,
expressed as proportion of time-series (0-1), default 0.15.}

\item{...}{other parameters}

\item{breaks}{(\code{testBreakPoints} only) \code{data.frame}
of The break-points and confidence intervals, typically a
\code{findBreakPoints} output.}
}
\value{
\code{findBreakPoints} returns a \code{data.frame}
of found break-points.

\code{testBreakPoints} return a likely break-point/segment
report.
}
\description{
Finding and testing break-points in
conventionally formatted air quality data sets.
}
\details{
\code{findBreakPoints} uses methods from
\code{strucchange} package (see references) and
modifications as suggested by the main author of
\code{strucchange} to handle missing cases to find
potential breaks-points in a supplied time-series.

\code{testBreakPoints} tests and identifies most likely
break-points using methods proposed for use with
\code{quantBreakPoints} and \code{quantBreakSegments}
and conventionally formatted air quality data sets.
}
\references{
Regarding \code{strucchange} methods see
\code{\link{breakpoints}}, and:

Achim Zeileis, Friedrich Leisch, Kurt Hornik and Christian Kleiber
(2002). strucchange: An R Package for Testing for Structural Change
in Linear Regression Models. Journal of Statistical Software, 7(2),
1-38. URL \url{https://www.jstatsoft.org/v07/i02/}.

Achim Zeileis, Christian Kleiber, Walter Kraemer and Kurt Hornik
(2003). Testing and Dating of Structural Changes in Practice.
Computational Statistics & Data Analysis, 44, 109-123.

Regarding missing data handling, see:

URL:
\url{https://stackoverflow.com/questions/43243548/strucchange-not-reporting-breakdates}.

Regarding \code{testBreakPoints}, see:

Ropkins et al (In Prep).
}
\seealso{
\code{\link{find.breaks}}.
}
