% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{rossler_system}
\alias{rossler_system}
\title{Rossler Chaotic System}
\usage{
rossler_system(n, dt, init_conditions, a, b, c, snr = Inf)
}
\arguments{
\item{n}{Number of time points (rounded to the nearest integer).}

\item{dt}{Time step between observations.}

\item{init_conditions}{Initial conditions as a numeric vector of length 3 (X, Y, Z).}

\item{a}{Rossler parameter 1}

\item{b}{Rossler parameter 2}

\item{c}{Rossler parameter 3}

\item{snr}{Signal-to-noise ratio (in dB). Use Inf for no noise.}
}
\value{
A numeric matrix representing the system's state over time. Each row
        corresponds to a time point, and each column represents a variable (X, Y, Z).
}
\description{
Simulates the Rossler chaotic system with optional noise.
}
\details{
This function simulates the Rossler chaotic system with the specified
parameters. It uses the specified time step and initial conditions to compute
the system's state over time. If a non-Infinite SNR is provided, Gaussian noise
is added to the system.
}
\examples{
# Simulate the Rossler system with 1000 time points and no noise
data <- rossler_system(
  n = 1000,
  dt = 0.01,
  init_conditions = c(0, 2, 0),
  a = 0.2, b = 0.2, c = 5.7,
  snr = Inf
)

}
