% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resASICS-class.R
\docType{methods}
\name{resASICS-getters}
\alias{resASICS-getters}
\alias{present_metabolites,resASICS-method}
\alias{present_metabolites}
\alias{original_mixture,resASICS-method}
\alias{original_mixture}
\alias{reconstituted_mixture,resASICS-method}
\alias{reconstituted_mixture}
\alias{ppm_grid,resASICS-method}
\alias{ppm_grid}
\title{S4 methods to represent results of ASICS.}
\usage{
\S4method{present_metabolites}{resASICS}(object)

\S4method{original_mixture}{resASICS}(object)

\S4method{reconstituted_mixture}{resASICS}(object)

\S4method{ppm_grid}{resASICS}(object)
}
\arguments{
\item{object}{an object of class resASICS}
}
\value{
The respective slot from resASICS object.
}
\description{
S4 methods to represent results of ASICS.
}
\examples{
\dontshow{
lib_file <- system.file("extdata", "library_for_examples.rda",
                        package = "ASICS")
cur_path <- system.file("extdata", "example_spectra", "AG_faq_Beck01",
                        package = "ASICS")
to_exclude <- matrix(c(4.5,5.1,5.5,6.5), ncol = 2, byrow = TRUE)
result <- ASICS(path = cur_path, exclusion.areas = to_exclude,
                nb.iter.signif = 10, library.metabolites = lib_file)

#Identified metabolites
present_metabolites(result)

}
\dontrun{
cur_path <- system.file("extdata", "example_spectra", "AG_faq_Beck01",
                        package = "ASICS")
to_exclude <- matrix(c(4.5,5.1,5.5,6.5), ncol = 2, byrow = TRUE)
result <- ASICS(path = cur_path, exclusion.areas = to_exclude)

#Identified metabolites
present_metabolites(result)

}
}
