% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aster_toa.R
\name{aster_toa}
\alias{aster_toa}
\title{ASTER DN to reflectance from multiple L1T hdf files}
\usage{
aster_toa(directory = getwd(), crop = "n", ext2crop = "none",
  radiance = 0)
}
\arguments{
\item{directory}{Path to ASTER hdf file/ files folder. Assign as string (inside double quotes).
Either assing inside function or set up satellite image folder as the current working directory
before running the function.
To define current working directory, either use shortcut key Ctrl+Shift+H  or use \code{\link{setwd}} funtion.}

\item{ext2crop, crop}{Same as mentioned in \code{\link[ASIP]{arvi}}.}

\item{radiance}{By default, this function won't produce radiance outputs. If required, assign value 1.}
}
\value{
An new output folder in the input directory. It contains different folders for each hdf file with name "date of data aquisition+fight direction" and
the converted TOA bands in respective folders.
}
\description{
Convert ASTER VNIR/SWIR bands from DN to radiance and to reflectance from source hdf files directly.
Multiple ASTER hdf files can be converted in a single run of this function.
}
\note{
1. Windows users users should be careful while assigning directory. Use "/" to seperate folders not "\\".

2. The base of this function is provided by Land processes distributed active archive center (LP DAAC).
Raw code is customized to produce this function with additional functionalities and more ease of use. Authors are thankful to Cole Krehbiel, LP DAAC, NASA and USGS.
}
\references{
\href{https://asterweb.jpl.nasa.gov/content/03_data/04_Documents/aster_user_guide_v2.pdf}{Abrams M, Hook S, and RAMACHANDRAN B, (1999) Aster user handbook,
Version 2, NASA/Jet Propulsion Laboratory, Pasadena, CA.}

\href{http://www.tandfonline.com/doi/abs/10.1080/014311698213768}{Eva H, AND Lambin E F, (1998) Burnt area mapping in Central Africa using
ATSER data, International Journal of Remote Sensing, 19 (18), 3473-3497. doi:10.1080/014311698213768.}

\href{http://dx.doi.org/10.1117/12.450668}{Thome, K.J., Biggar, S.F., and Slater, P.N., 2001, Effects of assumed solar
spectral irradiance on intercomparisons of earth-observing sensors. In
International Symposium on Remote Sensing, International Society for Optics
and Photonics, pp: 260-269. doi:10.1117/12.450668.}
}
