% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_generative_models.R
\name{create_Lmatrix}
\alias{create_Lmatrix}
\title{Make L matrix}
\usage{
create_Lmatrix(BM, nb_b, Ropt = 100, gamma = 2, th = 0.01)
}
\arguments{
\item{BM}{float vector, body mass of species.}

\item{nb_b}{integer, number of basal species.}

\item{Ropt}{numeric, consumer/resource optimal body mass ratio.}

\item{gamma}{numeric, the ... of the Ricker function.}

\item{th}{float, the threshold below which attack rates are considered = 0.}
}
\value{
A numeric matrix with the probability for an attack event between two
  species to be successful.
}
\description{
Make L matrix
}
\details{
The L matrix contains the probability for an attack event to be
  successful based on allometric rules and a Ricker function defined by
  \emph{Ropt} and \emph{gamma}. If at least one species has not resource or
  consumer (i.e. it is an isolated species), another food web is generated,
  until a maximum of 100 iterations.
}
\examples{
set.seed(123)
mass <- sort(10 ^ runif(30, 2, 6))
L <- create_Lmatrix(mass, nb_b = 10, Ropt = 100)
image(t(L))
}
