% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Unscaled_nuts}
\alias{Unscaled_nuts}
\title{Store parameters and functions associated to the unscaled version of ATN including nutrient dynamics}
\description{
Type the name of the class to see its methods
}
\section{Fields}{

\describe{
\item{\code{nb_s}}{Total number of species}

\item{\code{nb_b}}{Number of basal species}

\item{\code{nb_n}}{Number of nutrient pool}

\item{\code{c}}{double: interference competition}

\item{\code{b}}{Matrix of attack rates (dim = number of species * number of consumers)}

\item{\code{h}}{Matrix of handling times (dim = number of species * number of consumers)}

\item{\code{X}}{vector of metabolic rates (length = number of species)}

\item{\code{K}}{matrix of plant nutrient efficiencies (dim = number of nutrients * number of plants)}

\item{\code{V}}{matrix of plant relative nutrient content (dim = number of nutrients * number of plants)}

\item{\code{S}}{Vector of maximum nutrient concentration (length = number of plants)}

\item{\code{r}}{Vector of maximum growth rate of plant species (length = number of plant species)}

\item{\code{e}}{Vector of assimilation efficiencies (length = number of species)}

\item{\code{BM}}{Vector of body masses (length = number of species)}

\item{\code{dB}}{Vector of local derivatives (length = number of species)}

\item{\code{fw}}{Adjacency matrix of the food-web (dim = number of species * number of species)}

\item{\code{w}}{Matrix of relative consumption rates (dim = number of species * number of consumers)}

\item{\code{F}}{Matrix of per-capita feeding rates (dim = number of species * number of consumers)}

\item{\code{q}}{hill exponent for the type of functional response}

\item{\code{ext}}{Extinction threshold for species}

\item{\code{ODE}}{Calculate the derivatives for the scaled version of the ATN model \itemize{
\item Parameter: bioms -  Local species biomasses
\item Parameter: t - Integration time point
\item Returns a vector of growth rate for each species at time t
}}
}}

