% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ssir_epidemic.R
\name{plot.ssir_epidemic}
\alias{plot.ssir_epidemic}
\title{Plot method for a single SSIR epidemic simulation}
\usage{
\method{plot}{ssir_epidemic}(x, ...)
}
\arguments{
\item{x}{An object of class "ssir_epidemic", typically the result of calling ssir() with
rep = NULL or 1.}

\item{...}{Additional arguments passed to the underlying plotting function (currently unused).}
}
\value{
A grid arrangement of two ggplot objects: new infections and reported cases.
}
\description{
This function creates plots for a single SSIR (Stochastic Susceptible-Infectious-Removed)
epidemic simulation.
It generates two plots: one for new infections and one for reported cases.
}
\examples{
# Run a single simulation
result <- ssir(N = 10000, T = 300, alpha = 0.3, inf_period = 4, inf_init = 32,
report = 0.02, lag = 7)

# Plot the results
plot(result)
}
\seealso{
\code{\link{plot_single_epidemic}} for the underlying plotting function
}
