% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_muts.R
\name{format_muts}
\alias{format_muts}
\title{This function filters hypermutated samples and returns the formatted mutations with the appropriate trinucleotide context}
\usage{
format_muts(mutations, this_genome, filter_hyper_MB = NA)
}
\arguments{
\item{mutations}{A data frame with the following columns: chr, pos1, pos2, ref, alt, patient
\describe{
    \item{chr}{autosomal chromosomes as chr1 to chr22 and sex chromosomes as chrX and chrY}
    \item{pos1}{the start position of the mutation in base 1 coordinates}
    \item{pos2}{the end position of the mutation in base 1 coordinates}
    \item{ref}{the reference allele as a string containing the bases A, T, C or G}
    \item{alt}{the alternate allele as a string containing the bases A, T, C or G}
    \item{patient}{the patient identifier as a string}
}}

\item{this_genome}{The reference genome object of BSgenome}

\item{filter_hyper_MB}{The number of mutations per megabase for which a sample is considered hypermutated.
Hypermutated samples will be removed in further analyses.}
}
\value{
a data frame called mutations which has been formatted with an extra column for trinucleotide context
}
\description{
This function filters hypermutated samples and returns the formatted mutations with the appropriate trinucleotide context
}
\examples{
\donttest{
data(cll_mutations)
this_genome = BSgenome.Hsapiens.UCSC.hg19::Hsapiens
formatted_mutations = format_muts(cll_mutations[1:10,], 
		filter_hyper_MB = 30, this_genome = this_genome)
}
}
