% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddiVortesFit.R
\name{predict.AddiVortesFit}
\alias{predict.AddiVortesFit}
\title{Predict Method for AddiVortesFit}
\usage{
\method{predict}{AddiVortesFit}(
  object,
  newdata,
  type = c("response", "quantile"),
  quantiles = c(0.025, 0.975),
  interval = c("credible", "prediction"),
  showProgress = TRUE,
  parallel = TRUE,
  cores = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{AddiVortesFit}, typically the result of a
call to \code{AddiVortes()}.}

\item{newdata}{A matrix of covariates for the new test set. The number of
columns must match the original training data.}

\item{type}{The type of prediction required. The default \code{"response"} gives
the mean prediction. The alternative \code{"quantile"} returns the quantiles
specified by the \code{quantiles} argument.}

\item{quantiles}{A numeric vector of probabilities to
compute for the predictions when \code{type = "quantile"}.}

\item{interval}{The type of interval calculation. The default \code{"credible"}
accounts only for uncertainty in the mean (similar to \code{lm}'s confidence interval).
The alternative \code{"prediction"} also includes the model's error variance,
producing wider intervals (similar to \code{lm}'s prediction interval).}

\item{showProgress}{Logical; if TRUE (default), a progress bar is shown during prediction.}

\item{parallel}{Logical; if TRUE (default), predictions are computed in parallel.}

\item{cores}{The number of CPU cores to use for parallel processing. If NULL (default),
it defaults to one less than the total number of available cores.}

\item{...}{Further arguments passed to or from other methods (currently
unused).}
}
\value{
If \code{type = "response"}, a numeric vector of mean predictions.
If \code{type = "quantile"}, a matrix where each row corresponds to an observation
in \code{newdata} and each column to a quantile.
}
\description{
Predicts outcomes for new data using a fitted \code{AddiVortesFit} model object.
It can return mean predictions, quantiles and optionally calculate the
Root Mean Squared Error (RMSE) if true outcomes are provided.
}
\details{
This function relies on the internal helper function \code{applyScaling_internal}
being available in the environment, which is used by the main
\code{AddiVortes} function.

When \code{interval = "prediction"} and \code{type = "quantile"}, the function samples
additional Gaussian noise with variance equal to the sampled sigma squared
from the posterior. This accounts for the inherent variability in individual
predictions, not just uncertainty in the mean function. The noise is added
in the scaled space before unscaling predictions.
}
\examples{
\donttest{
# Fit a model
set.seed(123)
X <- matrix(rnorm(100), 20, 5)
Y <- rnorm(20)
fit <- AddiVortes(Y, X, m = 5, totalMCMCIter = 50, mcmcBurnIn = 10)

# New data for prediction
X_new <- matrix(rnorm(25), 5, 5)

# Mean predictions
pred_mean <- predict(fit, X_new, type = "response")

# Credible intervals (uncertainty in mean only)
pred_conf <- predict(fit, X_new, type = "quantile", 
                    interval = "credible",
                    quantiles = c(0.025, 0.975))

# Prediction intervals (includes error variance)
pred_pred <- predict(fit, X_new, type = "quantile",
                    interval = "prediction",
                    quantiles = c(0.025, 0.975))

# Prediction intervals are wider than credible intervals
mean(pred_pred[, 2] - pred_pred[, 1]) > mean(pred_conf[, 2] - pred_conf[, 1])
}

}
