% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{getCMA}
\alias{getCMA}
\title{Access the actual CMA estimate from a CMA object.}
\usage{
getCMA(
  x,
  flatten.medication.groups = FALSE,
  medication.groups.colname = ".MED_GROUP_ID"
)
}
\arguments{
\item{x}{a CMA object.}

\item{flatten.medication.groups}{\emph{Logical}, if \code{TRUE} and there are
medication groups defined, then the return value is flattened to a single
\code{data.frame} with an extra column containing the medication group (its
name is given by \code{medication.groups.colname}).}

\item{medication.groups.colname}{a \emph{string} (defaults to ".MED_GROUP_ID")
giving the name of the column storing the group name when
\code{flatten.medication.groups} is \code{TRUE}.}
}
\value{
a \emph{data.frame} containing the CMA estimate(s).
}
\description{
Retrieve the actual CMA estimate(s) encapsulated in a simple, per episode,
or sliding window CMA object.
}
\examples{
cma1 <- CMA1(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );
getCMA(cma1);
\dontrun{
cmaE <- CMA_per_episode(CMA="CMA1",
                        data=med.events,
                        ID.colname="PATIENT_ID",
                        event.date.colname="DATE",
                        event.duration.colname="DURATION",
                        event.daily.dose.colname="PERDAY",
                        medication.class.colname="CATEGORY",
                        carry.only.for.same.medication=FALSE,
                        consider.dosage.change=FALSE,
                        followup.window.start=0,
                        observation.window.start=0,
                        observation.window.duration=365,
                        date.format="\%m/\%d/\%Y"
                       );
getCMA(cmaE);}
}
