% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial2_function.R
\name{polynomial2}
\alias{polynomial2}
\title{Analysis: Linear regression graph in double factorial}
\usage{
polynomial2(
  fator1,
  resp,
  fator2,
  color = NA,
  grau = NA,
  ylab = "Response",
  xlab = "Independent",
  theme = theme_classic(),
  se = FALSE,
  point = "mean_sd",
  legend.title = "Treatments",
  posi = "top",
  textsize = 12,
  ylim = NA,
  family = "sans",
  width.bar = NA,
  pointsize = 3,
  linesize = 0.8,
  separate = c("(\\"", "\\")"),
  n = NA,
  DFres = NA,
  SSq = NA
)
}
\arguments{
\item{fator1}{Numeric or complex vector with factor 1 levels}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{fator2}{Numeric or complex vector with factor 2 levels}

\item{color}{Graph color (\emph{default} is NA)}

\item{grau}{Degree of the polynomial (1,2 or 3)}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{se}{Adds confidence interval (\emph{default} is FALSE)}

\item{point}{Defines whether to plot all points ("all"), mean ("mean"), mean with standard deviation ("mean_sd") or mean with standard error (\emph{default} - "mean_se").}

\item{legend.title}{Title legend}

\item{posi}{Legend position}

\item{textsize}{Font size (\emph{default} is 12)}

\item{ylim}{y-axis scale}

\item{family}{Font family (\emph{default} is sans)}

\item{width.bar}{width of the error bars of a regression graph.}

\item{pointsize}{Point size (\emph{default} is 4)}

\item{linesize}{line size (Trendline and Error Bar)}

\item{separate}{Separation between treatment and equation (\emph{default} is c("(\"","\")"))}

\item{n}{Number of decimal places for regression equations}

\item{DFres}{Residue freedom degrees}

\item{SSq}{Sum of squares of the residue}
}
\value{
Returns two or more linear, quadratic or cubic regression analyzes.
}
\description{
Linear regression analysis for significant interaction of an experiment with two factors, one quantitative and one qualitative
}
\examples{
dose=rep(c(0,0,0,2,2,2,4,4,4,6,6,6),3)
resp=c(8,7,5,23,24,25,30,34,36,80,90,80,
12,14,15,23,24,25,50,54,56,80,90,40,
12,14,15,3,4,5,50,54,56,80,90,40)
trat=rep(c("A","B","C"),e=12)
polynomial2(dose, resp, trat, grau=c(1,2,3))
}
\seealso{
\link{polynomial}, \link{polynomial2_color}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Experimental}
\keyword{regression}
