% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{regression}
\alias{regression}
\title{Analysis: Regression linear or nolinear}
\usage{
regression(
  trat,
  resp,
  model = "LM1",
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  point = "all"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{model}{model regression (\emph{default} is LM1)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function is a simplification of all the analysis functions present in the package.
}
\details{
To change the regression model, change the "model" argument to:
\itemize{
\item \strong{N:} Graph for not significant trend.
\item \strong{LM0.5:} Quadratic inverse regression.
\item \strong{LM1:} Linear regression.
\item \strong{LM2:} Quadratic regression.
\item \strong{LM3:} Cubic regression.
\item \strong{LM4:} Quartic regression.
\item \strong{LL3:} Three-parameter logistics.
\item \strong{LL4:} Four-parameter logistics.
\item \strong{BC4:} Logistic regression Brain-Cousens with four parameter.
\item \strong{BC5:} Logistic regression Brain-Cousens with five parameter.
\item \strong{CD4:} Logistic regression Cedergreen-Ritz-Streibig with four parameter.
\item \strong{CD5:} Logistic regression Cedergreen-Ritz-Streibig with fice parameter.
\item \strong{loess:} Loess non-parametric regression.
\item \strong{gaussian:} Gaussian model.
\item \strong{MM:} Michaelis-Menten.
\item \strong{linear.linear:} Linear-Linear regression.
\item \strong{linear.plateau:} Linear-plateau regression.
\item \strong{quadratic.plateau:} Quadratic-plateau regression.
\item \strong{exponential:} Exponential regression.
\item \strong{exponential_neg:} Exponential negative regression.
\item \strong{biexponential:} Biexponential regression.
\item \strong{log:} Logarithmic regression.
\item \strong{GP:} Gompertz regression.
}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
regression(trat, resp)
}
