% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowpres.R
\name{flowpres}
\alias{flowpres}
\title{Flow calculation as a function of working pressure}
\usage{
flowpres(q1, q2, p1, p2)
}
\arguments{
\item{q1}{Nozzle flow 1 (L/min)}

\item{q2}{Nozzle flow 2 (L/min)}

\item{p1}{Nozzle pressure 1 (bar)}

\item{p2}{Nozzle pressure 2 (bar)}
}
\value{
Returns values of flow (L/min) or pressure (bar)
}
\description{
This is a function to determine the flow rate of a spray nozzle as a function of the working pressure
}
\details{
Nozzle flow 1:
\deqn{q1=\frac{\sqrt{p1}}{\sqrt{p2}}*q2}
Nozzle flow 2:
\deqn{q2=\frac{q1}{\frac{\sqrt{p1}}{\sqrt{p2}}}}
Nozzle pressure 1:
\deqn{p1=(\sqrt{p2}*\frac{q1}{q2})^2}
Nozzle pressure 2:
\deqn{p2=(\frac{\sqrt{p1}}{(\frac{q1}{q2})})^2}
}
\examples{
flowpres(q1=NA,q2=0.80,p1=1.00,p2=2.80)
flowpres(q1=0.48,q2=0.80,p1=1.00,p2=NA)
}
\references{
ANDEF Associacao Nacional de Defesa Vegetal. Manual de tecnologia de aplicacao de produtos fitossanitarios. Campinas: Linea Creativa, 2004. 50p.

BOLLER, W.; RAETANO, C. G. Bicos e pontas de pulverizacao de energia hidraulica, regulagens e calibracao de pulverizadores de barras. In: ANTUNIASSI, U. R.; BOLLER, W. (Organizadores). Tecnologia de aplicacao para culturas anuais. Passo Fundo: Aldeia Norte; Botucatu: FEPAF, 2011. p.51-82.

SPRAYING SYSTEMS CO. Catalogo 51A-PT - Produtos de pulverizacao para agricultura. Wheaton: Spraying Systems Co., 2014. 160p.
}
\seealso{
\link{flowrat}
\link{product}
}
\author{
Rodrigo Yudi Palhaci Marubayashi, \email{marubayashi@uel.br}

Gabriel Danilo Shimizu

Otavio Jorge Grigoli Abi Saab
}
