% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_filterByDistance.R
\name{monitor_filterByDistance}
\alias{monitor_filterByDistance}
\title{Filter by distance from a target location}
\usage{
monitor_filterByDistance(
  monitor,
  longitude = NULL,
  latitude = NULL,
  radius = 50,
  count = NULL,
  addToMeta = FALSE
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{longitude}{Target longitude.}

\item{latitude}{Target.}

\item{radius}{Distance (m) of radius defining a target area.}

\item{count}{Number of time series to return.}

\item{addToMeta}{Logical specifying whether to add \code{distanceFromTarget}
as a field in \code{monitor$meta}.}
}
\value{
A \emph{mts_monitor} object with monitors near a location.
}
\description{
Filters the \code{monitor} argument to include only those time series
located within a certain radius of a target location. If no time series fall
within the specified \code{radius}, an empty \emph{mts_monitor} object will
be returned.

When \code{count} is used, a \emph{mts_monitor} object is
created containing \strong{up to} \code{count} time series, ordered by
increasing distance from the target location. Note that the number
of monitors returned may be less than the specified \code{count} value if
fewer than \code{count} time series are found within the target area.
}
\note{
The returned \emph{mts_monitor} will have an extra \code{distance}.  (A list with
\code{meta} and \code{data} dataframes.)
}
\examples{
library(AirMonitor)

# Walla Walla
longitude <- -118.330278
latitude <- 46.065

Walla_Walla_monitors <-
  NW_Megafires \%>\%
  monitor_filterByDistance(
    longitude = -118.330,
    latitude = 46.065,
    radius = 50000,     # 50 km
    addToMeta = TRUE
  )

Walla_Walla_monitors \%>\%
  monitor_getMeta() \%>\%
  dplyr::select(c("locationName", "distanceFromTarget"))

}
