% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_leaflet.R
\name{monitor_leaflet}
\alias{monitor_leaflet}
\title{Leaflet interactive map of monitor locations}
\usage{
monitor_leaflet(
  monitor,
  slice = "max",
  radius = 10,
  opacity = 0.7,
  maptype = "terrain",
  extraVars = NULL,
  jitter = 5e-04,
  NAAQS = c("PM2.5", "PM2.5_2024"),
  ...
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{slice}{Either a formatted time string, a time index, the name of a
(potentially user defined) function used to collapse the time axis.}

\item{radius}{radius of monitor circles}

\item{opacity}{opacity of monitor circles}

\item{maptype}{optional name of leaflet ProviderTiles to use, e.g. "terrain"}

\item{extraVars}{Character vector of additional column names from \code{monitor$meta}
to be shown in leaflet popups.}

\item{jitter}{Amount to use to slightly adjust locations so that multiple
monitors at the same location can be seen. Use zero or \code{NA} to see
precise locations.}

\item{NAAQS}{Version of NAAQS levels to use. See Note.}

\item{...}{Additional arguments passed to \code{leaflet::addCircleMarker()}.}
}
\value{
Invisibly returns a leaflet map of class "leaflet".
}
\description{
This function creates interactive maps that will be displayed in RStudio's
'Viewer' tab. The \code{slice} argument is used to collapse a
\emph{mts_monitor} timeseries into a single value. If \code{slice} is an
integer, that row index will be selected from the \code{monitor$data}
dataframe. If \code{slice} is a function (unquoted), that function will be
applied to the timeseries with the argument \code{na.rm=TRUE} (e.g.
\code{max(..., na.rm=TRUE)}).

If \code{slice} is a user defined function, it will be used with argument
\code{na.rm=TRUE} to collapse the time dimension. Thus, user defined
functions must accept \code{na.rm} as an argument.
}
\details{
The \code{maptype} argument is mapped onto leaflet "ProviderTile" names.
Current map types include:

\describe{
\item{"roadmap"}{ -- "OpenStreetMap"}
\item{"satellite"}{ -- "Esri.WorldImagery"}
\item{"terrain"}{ -- "Esri.WorldTopoMap"}
\item{"toner"}{ -- "Stamen.Toner"}
}

If a character string not listed above is provided, it will be used as the
underlying map tile if available. See
\url{https://leaflet-extras.github.io/leaflet-providers/} for a list of
"provider tiles" to use as the background map.
}
\note{
On February 7, 2024, EPA strengthened the National Ambient Air Quality
Standards for Particulate Matter (PM NAAQS) to protect millions of Americans
from harmful and costly health impacts, such as heart attacks and premature
death. Particle or soot pollution is one of the most dangerous forms of air
pollution, and an extensive body of science links it to a range of serious
and sometimes deadly illnesses. EPA is setting the level of the primary
(health-based) annual PM2.5 standard at 9.0 micrograms per cubic meter to
provide increased public health protection, consistent with the available
health science.
See \href{https://www.epa.gov/pm-pollution/final-reconsideration-national-ambient-air-quality-standards-particulate-matter-pm}{PM NAAQS update}.
}
\examples{
\dontrun{
library(AirMonitor)
# Fail gracefully if any resources are not available
try({

# Maximum AQI category at each site
monitor_loadLatest() \%>\%
  monitor_filter(stateCode \%in\% CONUS) \%>\%
  monitor_leaflet()

# Mean AQI category at each site
monitor_loadLatest() \%>\%
  monitor_filter(stateCode \%in\% CONUS) \%>\%
  monitor_leaflet(
    slice = "mean"
  )

# Mean AQI category at each site using the updated NAAQS
monitor_loadLatest() \%>\%
  monitor_filter(stateCode \%in\% CONUS) \%>\%
  monitor_leaflet(
    slice = "mean",
    NAAQS = "PM2.5_2024"
  )

}, silent = FALSE)
}
}
