% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_filterMeta.R
\name{sensor_filterMeta}
\alias{sensor_filterMeta}
\title{Metadata filtering for AirSensor objects}
\usage{
sensor_filterMeta(sensor = NULL, ...)
}
\arguments{
\item{sensor}{An AirSensor object.}

\item{...}{Logical predicates defined in terms of the variables in 
\code{sensor$meta}.}
}
\value{
A subset of the incoming \emph{sensor}.
}
\description{
A generalized data filter for \emph{sensor} objects to 
choose rows/cases where conditions are true.  Multiple conditions are 
combined with \code{&} or seperated by a comma. Only rows where the condition 
evaluates to TRUE are kept.Rows where the condition evaluates to \code{NA}
are dropped.
}
\note{
Filtering predicates are applied to the \code{meta} dataframe within
the \emph{sensor} object.
}
\examples{
library(AirSensor)

example_sensor_scaqmd \%>\%
  sensor_extractMeta() \%>\%
  dplyr::pull("communityRegion") \%>\%
  sort () \%>\%
  unique()
  
example_sensor_scaqmd \%>\%
  sensor_filterMeta(communityRegion == "Imperial Valley") \%>\%
  sensor_extractMeta() \%>\%
  dplyr::pull("communityRegion") \%>\%
  sort () \%>\%
  unique()

}
\seealso{
\link{sensor_filter}

\link{sensor_filterDate}
}
