% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_pollutionRose.R
\name{sensor_pollutionRose}
\alias{sensor_pollutionRose}
\title{Pollution rose plot}
\usage{
sensor_pollutionRose(
  sensor = NULL,
  windData = NULL,
  statistic = "prop.count",
  key = TRUE,
  keyPosition = "right",
  annotate = TRUE,
  angle = 30,
  angleScale = 315,
  gridLine = NULL,
  breaks = 6,
  paddle = FALSE,
  seg = 0.9,
  normalize = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{sensor}{an 'airsensor' object}

\item{windData}{a dataframe containing columns "date", "ws", and "wd".}

\item{statistic}{The statistic to be applied to each data bin in the plot. 
Options currently include “prop.count”, “prop.mean” and “abs.count”. 
The default “prop.count” sizes bins according to the proportion of the 
frequency of measurements. Similarly, “prop.mean” sizes bins according to 
their relative contribution to the mean. “abs.count” provides the absolute 
count of measurements in each bin.}

\item{key}{control of the scale key via drawOpenKey. See drawOpenKey for 
further details.}

\item{keyPosition}{location where the scale key is to plotted. Allowed 
arguments currently include “top”, “right”, “bottom” and “left”.}

\item{annotate}{If TRUE then the percentage calm and mean values are printed 
in each panel together with a description of the statistic below the plot. 
If " " then only the stastic is below the plot. Custom annotations may be 
added by setting value to c("annotation 1", "annotation 2").}

\item{angle}{default angle of “spokes” is 30. Other potentially useful angles
are 45 and 10. Note: the width of the wind speed interval may need adjusting
using width.}

\item{angleScale}{The wind speed scale is by default shown at a 315 degree 
angle. Sometimes the placement of the scale may interfere with an interesting
feature. The user can therefore set angle.scale to another value (between 0 
and 360 degrees) to mitigate such problems. For example angleScale = 45 will
draw the scale heading in a NE direction.}

\item{gridLine}{Grid line interval to use. If NULL, as in default, this is 
assigned by based on the available data range. However, it can also 
be forced to a specific value, e.g. gridLine = 10. grid.line can also be a 
list to control the interval, line type and colour. For example 
gridLine = list(value = 10, lty = 5, col = "purple").}

\item{breaks}{the number of break points for wind speed in pollutant}

\item{paddle}{Either TRUE (default) or FALSE. If TRUE plots rose using 
‘paddle’ style spokes. If FALSE plots rose using ‘wedge’ style spokes.}

\item{seg}{determines with width of the segments. For example, seg = 0.5 will
produce segments 0.5 * angle.}

\item{normalize}{if TRUE each wind direction segment is normalized to equal 
one. This is useful for showing how the concentrations (or other parameters) 
contribute to each wind sector when the proprtion of time the wind is from 
that direction is low. A line showing the probability that the wind.}

\item{verbose}{Logical controlling the generation of progress and error messages.}
}
\value{
a plot or a dataframe
}
\description{
Plots a traditional wind rose plot for wind direction and PM2.5.
}
\examples{
\donttest{
library(AirSensor)

# Set default location of pre-generated data files
setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

pas <- pas_load(archival = TRUE)
pat <- pat_loadMonth(label = "SCBB_02", pas = pas, datestamp = 202005)
sensor <- pat_createAirSensor(pat)

# Load wind data from NOAA
windData <- worldmet::importNOAA(
  code = "722975-53141", 
  year = 2020
)
windData <- dplyr::select(windData, c("date", "wd", "ws"))

# Plot rose using mean binning
sensor_pollutionRose(sensor, windData, statistic = "prop.mean")
}
}
\seealso{
\url{https://davidcarslaw.github.io/openair/reference/windRose.html}
}
