% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_alignments.R
\name{compare_alignments}
\alias{compare_alignments}
\title{Compare alternative multiple sequence alignments}
\usage{
compare_alignments(ref, com, SP = FALSE)
}
\arguments{
\item{ref}{The reference MSA (in fasta, clustal, msf, phylip or mase format)}

\item{com}{The MSA to compare (in fasta, clustal, msf, phylip or mase format)}

\item{SP}{Optionally also compute sum of pairs scores (default=FALSE)}
}
\value{
Generates an object of class "pairwise alignment comparison" (PAC), providing the optimal pairwise column alignment of two alternative MSAs of the same sequences, and summary statistics of the differences between them. The details of the PAC output components are as follows:
\itemize{
 \item {reference_P}          {The numbered character matrix of the reference alignment}
 \item {comparison_Q}         {The numbered character matrix of the comparison alignment}
 \item {results_R}            {The results summary matrix (containing column averages of match, gapcon, merge, split, shift)}
 \item {similarity_S}         {The similarity matrix between the reference and comparison alignment columns}
 \item {dissimilarity_D}      {The dissimilarity matrix between the reference and comparison (containing match, gapcon, merge, split, shift)}
 \item {dissimilarity_simple} {The dissimilarity matrix with categories stacked into a single 2D matrix}
 \item {columnmatch}          {The column of the comparison alignment with the highest final match score}
 \item {cys}                  {The proportion of cysteines (relevant for cysteine rich proteins)}
 \item {reflen}               {The length of the reference alignment}
 \item {comlen}               {The length of the comparison alignment}
 \item {refcon}               {The consensus sequence of the reference alignment}
 \item {comcon}               {The consensus sequence of the comparison alignment}
 \item {similarity_score}     {The overall similarity score}
 \item {sum_of_pairs}         {The sum of pairs score and related data (optional)}
}
}
\description{
Compare alternative multiple sequence alignments
}
\note{
The `compare_alignments` compares two alternative multiple sequence alignments (MSAs) of the same sequences. The alternative alignments must contain the same sequences. The function classifies similarities and differences between the two MSAs. It produces the "pairwise alignment comparison" object required as the first step any other package functions. The function converts the MSAs into matrices of sequence characters labelled by their occurrence number in the sequence (e.g. to distinguish between the first and second cysteines of a sequence). It then compares the two MSAs to determine which columns have the highest similarty between the reference and comparison MSAs to generate a similarity matrix (excluding conserved gaps). From this matrix, the comparison alignment column with the similarity to each reference alignment column is used to calculate further statistics for dissimilarity matrix, summarised for each reference MSA column in the results matrix. Lastly, it calculates the overall similarity score between the two MSAs.
}
\examples{
data(reference_alignment)
data(comparison_alignment)
PAC <- compare_alignments(reference_alignment,comparison_alignment)

}

