% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summaryAlphaPart.R
\name{print.summaryAlphaPart}
\alias{print.summaryAlphaPart}
\title{print.summaryAlphaPart.R}
\usage{
\method{print}{summaryAlphaPart}(x, ...)
}
\arguments{
\item{x}{summaryAlphaPart, output object from \code{\link[AlphaPart]{summary.AlphaPart}} function.}

\item{...}{Arguments passed to other functions (not used at the moment).}
}
\description{
Print method for objects of the class summaryAlphaPart.
}
\details{
Print method for objects of the class \code{summaryAlphaPart} (result of
\code{summary(AlphaPart(...))}).
}
\examples{
## Load an example data
data("AlphaPart.ped")

## --- Partition additive genetic values by loc ---
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc", colAGV=c("agv1", "agv2")))

## Summarize whole population
(ret <- summary(res))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Summarize population by generation (=trend) and location 1
(ret <- summary(res, by="loc.gen"))

## Summarize population by generation (=trend) but only for location 1
(ret <- summary(res, by="gen", subset=res[[1]]$loc == 1))

## --- Partition additive genetic values by loc and sex ---

AlphaPart.ped$loc.sex <- with(AlphaPart.ped, paste(loc, sex, sep="-"))
(res <- AlphaPart(x=AlphaPart.ped, colPath="loc.sex", colAGV=c("agv1", "agv2")))

## Summarize population by generation (=trend)
(ret <- summary(res, by="gen"))

## Summarize population by generation (=trend) and location 1
(ret <- summary(res, by="loc.gen"))

## Summarize population by generation (=trend) but only for location 1
(ret <- summary(res, by="gen", subset=res[[1]]$loc == 1))
}
\seealso{
\code{\link[AlphaPart]{summary.AlphaPart}}
}
