% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedSetBase.R
\name{pedSetBase}
\alias{pedSetBase}
\title{pedSetBase.R}
\usage{
pedSetBase(
  x,
  keep = NULL,
  unknown = NA,
  report = TRUE,
  colId = 1,
  colFid = 2,
  colMid = 3
)
}
\arguments{
\item{x}{data.frame , with (at least) the following columns: individual, father, and mother identification,
and year of birth; see arguments \code{colId},
\code{colFid}, \code{colMid}, and \code{colBY}}

\item{keep}{Logical, indicator that defines which individuals should stay in the
the pedigree; see details.}

\item{unknown}{Value used to represent unknown/missing identification}

\item{report}{Logical, report success.}

\item{colId}{Numeric or character, position or name of a column holding individual identification.}

\item{colFid}{Numeric or character, position or name of a column holding father identification.}

\item{colMid}{Numeric or character, position or name of a column holding mother identification.}
}
\value{
Object \code{x} with removed rows for some individuals and their presence as parents.
If \code{report=TRUE} progress is printed on the screen.
}
\description{
A function to set the base population in the pedigree.
}
\details{
Base population in the pedigree is set by removing rows for some individuals, while their
presence as parents is also removed.

Arguments \code{down} and \code{na.rm} allow for repeated use of this function, i.e., with
\code{down=FALSE} and with \code{down=TRUE} (both in combination with \code{na.rm=TRUE}) in order to
propagate information over the pedigree until "convergence".

This function can be very slow on large pedigrees with extensive missingness of birth years.
}
\examples{
## Example pedigree
ped <- data.frame(      id=1:10,
                       fid=c(0, 0, 0, 1, 1, 1, 3, 3, 3, 5),
                       mid=c(0, 0, 0, 2, 0, 2, 2, 2, 5, 0),
                  birth_dt=c(0, 0, 1, 2, 3, 3, 3, 4, 4, 5) + 2000)

## Set base population as those individuals that were born after year 2002
pedSetBase(x=ped, keep=ped$birth_dt > 2002, unknown=0)

}
\seealso{
\code{\link[pedigree]{orderPed}} in \pkg{pedigree} package
}
