% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossing.R
\name{makeCross}
\alias{makeCross}
\title{Make designed crosses}
\usage{
makeCross(pop, crossPlan, nProgeny = 1, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{crossPlan}{a matrix with two column representing 
female and male parents. Either integers for the position in 
population or character strings for the IDs.}

\item{nProgeny}{number of progeny per cross}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Makes crosses within a population using a user supplied 
crossing plan.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Cross individual 1 with individual 10
crossPlan = matrix(c(1,10), nrow=1, ncol=2)
pop2 = makeCross(pop, crossPlan, simParam=SP)

}
