% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r, R/hardwareSprites.r,
%   R/iff.ilbm.r, R/workbench_icon.r
\name{as.raster}
\alias{as.raster}
\alias{as.raster.AmigaBitmapFont}
\alias{as.raster}
\alias{as.raster.AmigaBitmapFontSet}
\alias{as.raster}
\alias{as.raster.hardwareSprite}
\alias{as.raster,hardwareSprite-method}
\alias{as.raster}
\alias{as.raster.IFFChunk}
\alias{as.raster}
\alias{as.raster.AmigaIcon}
\title{Convert AmigaFFH objects into grDevices raster images}
\usage{
\method{as.raster}{AmigaBitmapFont}(x, text, style, palette, ...)

\method{as.raster}{AmigaBitmapFontSet}(x, text, style, palette, ...)

\method{as.raster}{hardwareSprite}(x, background = "#AAAAAA", ...)

\method{as.raster}{IFFChunk}(x, ...)

\method{as.raster}{AmigaIcon}(x, selected = F, ...)
}
\arguments{
\item{x}{Object that needs to be converted into a \code{grDevices} raster. It
can be an \code{\link{IFFChunk}} containing an interleaved bitmap image
(ILBM) or animation (ANIM), a \code{\link{hardwareSprite}}, an
\code{\link{AmigaBitmapFont}} object or an \code{\link{AmigaBitmapFontSet}} object.}

\item{text}{Text (a \code{character} string) to be formated
with \code{x} (when \code{x} is an \code{\link{AmigaBitmapFont}}
or an \code{\link{AmigaBitmapFontSet}}.}

\item{style}{Argument is only valid when \code{x} is an \code{\link{AmigaBitmapFont}}
or an \code{\link{AmigaBitmapFontSet}}. No styling is applied
when missing or \code{NULL}. One or more of the following styles
can be used '\code{bold}', '\code{italic} or '\code{underlined}'.}

\item{palette}{Argument is only valid when \code{x} is an \code{\link{AmigaBitmapFont}}
or an \code{\link{AmigaBitmapFontSet}}. Should be a \code{vector} of
two colours. The first is element is used as background colour, the
second as foreground. When missing, transparent white and black are used.}

\item{...}{Currently ignored.}

\item{background}{Use the argument \code{background} to
specify a background colour in case \code{x} is a \code{\link{hardwareSprite}}.}

\item{selected}{This argument is only allowed when \code{x} is an object of class
\code{\link{AmigaIcon}}. When set to \code{TRUE}, the raster of the \code{\link{AmigaIcon}}
will be based on the `selected' state of the icon. Otherwise it will be based on the
unselected state (default).}
}
\value{
Returns a \code{grDevices} raster image (\code{\link[grDevices]{as.raster}})
based on \code{x}. If \code{x} is an animation (\code{\link{IFFChunk}} of type ANIM),
a \code{list} of raster objects is returned.
}
\description{
Convert AmigaFFH objects that contain bitmap images into grDevices raster
images.
}
\details{
Images on the Amiga were stored as bitmap images with indexed colour
palettes. This was mainly due to hardware and memory limitations.
Bitmap images could also be embedded in several file types. This method
can be used to convert AmigaFFH objects read from such files into
grDevices raster images (\code{\link[grDevices]{as.raster}}).
}
\examples{
\dontrun{
## load an IFF file
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## The file contains an interleaved bitmap image that can be
## converted into a raster:
example.raster <- as.raster(example.iff)

## the raster can be plotted:
plot(example.raster)

## note that the IFFChunk can also be plotted directly:
plot(example.iff)

## Hardware sprites can also be converted into raster images.
## Let's generate a 16x16 sprite with a random bitmap:
spr <- new("hardwareSprite",
           VStop = 16,
           bitmap = as.raw(sample.int(255, 64, replace = TRUE)))

## now convert it into a raster image.
## as the background colour is not specified for hardware
## sprite, we can optionally provide it here.
spr.raster <- as.raster(spr, background = "green")
}
}
\seealso{
Other iff.operations: \code{\link{IFFChunk-class}},
  \code{\link{WaveToIFF}}, \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{rawToIFFChunk}},
  \code{\link{read.iff}}, \code{\link{write.iff}}

Other raster.operations: \code{\link{AmigaBitmapFont}},
  \code{\link{bitmapToRaster}}, \code{\link{dither}},
  \code{\link{index.colours}},
  \code{\link{rasterToAmigaBitmapFont}},
  \code{\link{rasterToBitmap}},
  \code{\link{rasterToHWSprite}}, \code{\link{rasterToIFF}}
}
\author{
Pepijn de Vries
}
