% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r, R/generic_support.r,
%   R/hardwareSprites.r, R/iff.0.r, R/system_configuration.r, R/workbench_icon.r
\docType{methods}
\name{as.raw}
\alias{as.raw}
\alias{as.raw.AmigaBitmapFont}
\alias{as.raw}
\alias{as.raw.AmigaBitmapFontSet}
\alias{as.raw}
\alias{as.raw.AmigaTimeVal}
\alias{as.raw}
\alias{as.raw,hardwareSprite-method}
\alias{as.raw}
\alias{as.raw,IFFChunk-method}
\alias{as.raw.IFF.ANY}
\alias{as.raw}
\alias{as.raw.SysConfig}
\alias{as.raw}
\alias{as.raw.AmigaIcon}
\title{Convert AmigaFFH objects into raw data}
\usage{
\method{as.raw}{AmigaBitmapFont}(x, ...)

\method{as.raw}{AmigaBitmapFontSet}(x, ...)

\method{as.raw}{AmigaTimeVal}(x, ...)

\S4method{as.raw}{hardwareSprite}(x)

\S4method{as.raw}{IFFChunk}(x)

\method{as.raw}{IFF.ANY}(x, ...)

\method{as.raw}{SysConfig}(x, ...)

\method{as.raw}{AmigaIcon}(x, ...)
}
\arguments{
\item{x}{An AmigaFFH object that needs to be converted into raw data.
See usage section for all supported objects.}

\item{...}{Arguments passed on to \code{\link{IFFChunk-method}} when \code{x} is
of class \code{IFF.ANY}.}
}
\value{
Returns a \code{vector} of \code{raw} data based on \code{x}.
}
\description{
Convert AmigaFFH objects into raw data, as they would be stored in the Commodore
Amiga's memory or files.
}
\details{
Objects originating from this package can in some cases be converted into
raw data, as they would be stored on an original Amiga. See the usage section
for the currently supported objects.

Not all information from \code{x} may be included in the \code{raw}
data that is returned, so handle with care.

As this package grows additional objects can be converted with this method.
}
\examples{
\dontrun{
## read an IFF file as an IFFChunk object:
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## This will recreate the exact raw data as it was read from the file:
example.raw <- as.raw(example.iff)
}
}
\seealso{
Other raw.operations: \code{\link{colourToAmigaRaw}},
  \code{\link{packBitmap}},
  \code{\link{rawToAmigaBitmapFontSet}},
  \code{\link{rawToAmigaBitmapFont}},
  \code{\link{rawToAmigaIcon}},
  \code{\link{rawToHWSprite}}, \code{\link{rawToIFFChunk}},
  \code{\link{rawToSysConfig}},
  \code{\link{simpleAmigaIcon}}
}
\author{
Pepijn de Vries
}
