% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{as.character}
\alias{as.character}
\alias{as.character.AmigaBasic}
\title{Coerce an AmigaBasic class object to its character representation}
\usage{
\method{as.character}{AmigaBasic}(x, ...)
}
\arguments{
\item{x}{An \code{\link[=AmigaBasic]{AmigaBasic()}} class object that needs to be
coerced to its \code{character} representation.}

\item{...}{Currently ignored.}
}
\value{
A \code{vector} of \code{character} strings, where
each element of the \code{vector} is a \code{character} representation
of a line of Amiga Basic code stored in \code{x}.
}
\description{
Coerce an \code{\link[=AmigaBasic]{AmigaBasic()}}-class object to its character representation
}
\details{
Amiga Basic files are encoded in a binary format and are also stored as such
in \code{\link[=AmigaBasic]{AmigaBasic()}}-class objects. Use this function to convert
these objects into legible \code{character} data.
}
\examples{
## First create an Amiga Basic object:
bas <- as.AmigaBasic("PRINT \"Hello world!\"")

## now convert the object back into text:
bas.txt <- as.character(bas)
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{write.AmigaBasic}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
