% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getCodonCountsForAA}
\alias{getCodonCountsForAA}
\title{Get Codon Counts For Each Amino Acid}
\usage{
getCodonCountsForAA(aa, genome)
}
\arguments{
\item{aa}{A one character representation of an amino acid.}

\item{genome}{A genome object from which the counts of each
codon can be obtained.}
}
\value{
Returns a matrix storing the codonCounts for the given amino acid.
}
\description{
provides the codon counts for a fiven amino acid across all genes
}
\details{
The returned matrix containes a row for each gene and a coloumn for each codon.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
 
## reading genome
genome <- initializeGenomeObject(file = genome_file)
countsForA <- getCodonCountsForAA("A", genome)

counts <- lapply(X = c("A", "C"), FUN = getCodonCountsForAA, genome = genome)

}
