% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{findOptimalCodon}
\alias{findOptimalCodon}
\title{Find and return list of optimal codons}
\usage{
findOptimalCodon(csp)
}
\arguments{
\item{csp}{a \code{data.frame} as returned by \code{getCSPEstimates}.}
}
\value{
A named list with with optimal codons for each amino acid.
}
\description{
\code{findOptimalCodon} extracrs the optimal codon for each amino acid.
}
\examples{
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- 1
numMixtures <- 1
geneAssignment <- rep(1, length(genome))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
model <- initializeModelObject(parameter = parameter, model = "ROC")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE, 
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)

csp_mat <- getCSPEstimates(parameter, CSP="Selection")
opt_codons <- findOptimalCodon(csp_mat)
}
}
