% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getNames}
\alias{getNames}
\title{Gene Names of Genome}
\usage{
getNames(genome, simulated = FALSE)
}
\arguments{
\item{genome}{A genome object initialized with \code{\link{initializeGenomeObject}}.}

\item{simulated}{A logical value denoting if the gene names to be listed are simulated or not.
The default value is FALSE.}
}
\value{
gene.names Returns the names of the genes as a vector of strings.
}
\description{
returns the identifiers of the genes within the genome specified.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
 
## reading genome
genome <- initializeGenomeObject(file = genome_file)

## return all gene ids for the genome
geneIDs <- getNames(genome, FALSE)

}
