% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{loadParameterObject}
\alias{loadParameterObject}
\title{Load Parameter Object}
\usage{
loadParameterObject(files)
}
\arguments{
\item{files}{A list of parameter filenames to be loaded. If multiple files are given,
the parameter objects will be concatenated in the order provided}
}
\value{
Returns an initialized Parameter object.
}
\description{
\code{loadParameterObject} will load a parameter object from the filesystem
}
\details{
The function loads one or multiple files. In the case of multiple file, e.g. due to the use of check pointing, the files will
be concatenated to one parameter object. See \link{writeParameterObject} for the writing of parameter objects
}
\examples{
\dontrun{
# load a single parameter object
parameter <- loadParameterObject("parameter.Rda")

# load and concatenate multiple parameter object
parameter <- loadParameterObject(c("parameter1.Rda", "parameter2.Rda"))
}

}
