% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\title{Principal Component Analysis (PCA)}
\usage{
pca(
  data,
  variance_threshold = 0.9,
  center = TRUE,
  scale = FALSE,
  scree_plot = FALSE,
  biplot = FALSE,
  choices = 1:2,
  groups = NULL,
  length_scale = 1,
  scree_legend = TRUE,
  scree_legend_pos = c(0.7, 0.5),
  html = FALSE
)
}
\arguments{
\item{data}{Numeric matrix or data frame containing the variables for PCA.}

\item{variance_threshold}{Proportion of total variance to retain (default: 0.90).}

\item{center}{Logical, indicating whether to center the data (default: TRUE).}

\item{scale}{Logical, indicating whether to scale the data (default: FALSE).}

\item{scree_plot}{Logical, whether to generate a scree plot (default: FALSE).}

\item{biplot}{Logical, whether to generate a biplot (default: FALSE).}

\item{choices}{Numeric vector of length 2, indicating the principal components to plot in the biplot.}

\item{groups}{Optional grouping variable for coloring points in the biplot.}

\item{length_scale}{Scaling factor for adjusting the length of vectors in the biplot (default: 1).}

\item{scree_legend}{Logical, indicating whether to show legend in scree plot (default: True).}

\item{scree_legend_pos}{A vector c(x, y) to adjust the position of the legend.}

\item{html}{Whether the output should be in HTML format,used when knitting into HTML. Default is FALSE.}
}
\value{
A list containing:
 - summary_table: A matrix summarizing eigenvalues and cumulative variance explained.
 - scree_plot: A scree plot if scree_plot is TRUE.
 - biplot: A biplot if biplot is TRUE.
}
\description{
This function performs Principal Component Analysis (PCA) on the input data, providing
  a detailed analysis of variance, eigenvalues, and eigenvectors. It offers options to generate
  a scree plot for visualizing variance explained by each principal component and a biplot to
  understand the relationship between variables and observations in reduced dimensions.
}
\examples{
data(mtcars)
pca_result <- pca(mtcars, scree_plot = TRUE, biplot = TRUE)
pca_result$summary_table
pca_result$scree_plot
pca_result$biplot

}
