% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_diff_genes.R
\name{check_diff_genes}
\alias{check_diff_genes}
\title{Check a list of genes how they show difference.}
\usage{
check_diff_genes(gene, genes_expr, group_list)
}
\arguments{
\item{gene}{A vector contains all gene ids of interest. Gene ids should
be gene symbol.}

\item{genes_expr}{An expression matrix, the rownames should be  gene symbol.}

\item{group_list}{A vector contains the group information of each samples in  expression matrix}
}
\value{
A figure : boxplot or heatmap
}
\description{
How does a gene or a list of genes show difference between two group.
The boxplot or heatmap will be drawed.
just a wrap function of ggpubr and pheatmap.
}
\examples{
attach(GSE95166)
check_diff_genes('LRCH3',genes_expr,group_list )
\donttest{
x=DEG$logFC
names(x)=rownames(DEG)
cg=c(names(head(sort(x),100)),  names(tail(sort(x),100)))
check_diff_genes(cg,genes_expr,group_list )
}
}
