% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_prior.R
\name{AM_prior_K_Delta}
\alias{AM_prior_K_Delta}
\title{Computes the prior on the number of clusters}
\usage{
AM_prior_K_Delta(n, gamma, Mstar)
}
\arguments{
\item{n}{The sample size.}

\item{gamma}{The \code{gamma} parameter of the Dirichlet distribution.}

\item{Mstar}{The number of component of the mixture.}
}
\value{
an \code{\link{AM_prior}} object, that is a vector of length n, reporting the values \code{V(n,k)} for \code{k=1,...,n}.
}
\description{
This function computes the prior on the number of clusters, i.e. occupied components of the mixture for a Finite Dirichlet process
when the prior on the component-weights of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormalised weights
are distributed as Gamma(\eqn{\gamma},1)). This function can be used when the number of components is fixed to \eqn{M^*}, i.e.
a Dirac prior assigning mass only to \eqn{M^*} is assumed. See \insertCite{argiento2019infinity}{AntMAN} There are no default values.
}
\examples{
n <- 82
gam_de <- 0.1743555
Mstar <- 12
prior_K_de <- AM_prior_K_Delta(n,gam_de, Mstar)
plot(prior_K_de)
}
\keyword{cluster}
\keyword{number}
\keyword{of}
\keyword{prior}
