% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_binder.R
\name{AM_salso}
\alias{AM_salso}
\title{Sequentially Allocated Latent Structure Optimisation}
\source{
David B. Dahl and Devin J. Johnson and Peter Müller (2021). salso: Search Algorithms and Loss Functions for Bayesian Clustering. R package version 0.2.15.
}
\usage{
AM_salso(
  eam,
  loss,
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  probSequentialAllocation = 0.5,
  nCores = 0
)
}
\arguments{
\item{eam}{a co-clustering/ clustering matrix. See salso for more information on which matrix to use.}

\item{loss}{the recommended loss functions to be used are the "binder" or "VI". However, other loss functions that are supported
can be found in the R-package salso's salso function.}

\item{maxNClusters}{Maximum number of clusters to be considered.
The actual number of clusters searched may be lower. Default is 0.}

\item{nRuns}{Number of runs to try.}

\item{maxZealousAttempts}{Maximum number of tries for zealous updates. See salso for more information.}

\item{probSequentialAllocation}{The probability of using sequential allocation instead of random sampling via sample(1:K,ncol(x),TRUE),
where K is maxNClusters. Default is 0.5. See salso for more information.
argument.}

\item{nCores}{Number of CPU cores to engage. Default is 0.}
}
\value{
A numeric vector describing the estimated partition. The integer values represent the cluster labels of each item respectively.
}
\description{
Heuristic partitioning to minimise the expected loss function
with respect to a given expected adjacency matrix. This function is built upon R-package salso's implementation of the
\code{salso} function. See salso \insertCite{salso}{AntMAN} for more details.
}
