% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{read.apache.log}
\alias{read.apache.log}
\title{read.apache.log}
\usage{
read.apache.log(file, format = "combined", url_includes = "",
  url_excludes = "", url_query_string = TRUE, url_http_version = TRUE,
  url_http_method = TRUE, columns = c("ip", "datetime", "url", "httpcode",
  "size", "referer", "useragent"), num_cores = 1,
  prevent_quotes_inside_url = FALSE)
}
\arguments{
\item{file}{string. Full path to the log file.}

\item{format}{string. Values "common" or "combined" to set the input log format. The default value is the combined.}

\item{url_includes}{regex. If passed only the urls that matches with the regular expression passed will be returned.}

\item{url_excludes}{regex. If passed only the urls that don't matches with the regular expression passed will be returned.}

\item{url_query_string}{boolean. If the query string will be included in url column.}

\item{url_http_version}{booelan. If the http version will be included in url column.}

\item{url_http_method}{boolean. If the http method will be included in url column.}

\item{columns}{list. List of columns names that will be included in data frame output. All columns is the default value. c("ip", "datetime", "url", "httpcode", "size" , "referer", "useragent")}

\item{num_cores}{number. Number of cores for parallel execution, if not passed 1 core is assumed. Used only to convert datetime form string to datetime type.}

\item{prevent_quotes_inside_url}{boolean. Search and remove the quotes inside the url field.}
}
\value{
a data frame with the apache log file information.
}
\description{
Reads the Apache Log Common or Combined Format and return a data frame with the log data.
}
\details{
The functions recives a full path to the log file and process the default log in common or combined format of Apache. 
LogFormat "\%h \%l \%u \%t \\"\%r\\" \%>s \%b \\"\%\{Referer\}i\\" \\"\%\{User-Agent\}i\\"" combined
LogFormat "\%h \%l \%u \%t \\"\%r\\" \%>s \%b\\" common
}
\examples{
path_combined = system.file("examples", "access_log_combined.txt", package = "ApacheLogProcessor")
path_common = system.file("examples", "access_log_common.txt", package = "ApacheLogProcessor")

#Read a log file with combined format and return it in a data frame
df1 = read.apache.log(path_combined)

#Read a log file with common format and return it in a data frame
df2 = read.apache.log(path_common, format="common") 

#Read only the lines that url matches with the pattern passed
df3 = read.apache.log(path_combined, url_includes="infinance")

#Read only the lines that url matches with the pattern passed, but do not matche the exclude pattern
df4 = read.apache.log(path_combined, url_includes="infinance", url_excludes="infinanceclient")

#Removes the method and query string from urls
df5 = read.apache.log(path_combined, url_http_method=FALSE, url_query_string=FALSE)

#Return only the ip, url and datetime columns
df6 = read.apache.log(path_combined, columns=c("ip", "url", "datetime"))

#Process using 2 cores in parallel for speed up. 
df7 = read.apache.log(path_combined, num_cores=2)


}
\author{
Diogo Silveira Mendonca
}
\seealso{
\url{http://httpd.apache.org/docs/1.3/logs.html}
}

