% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle-weight-files.R
\name{import.pgs.weight.file}
\alias{import.pgs.weight.file}
\title{Import PGS weight file}
\usage{
import.pgs.weight.file(pgs.weight.path, use.harmonized.data = TRUE)
}
\arguments{
\item{pgs.weight.path}{A character string indicating the path to the pgs weight file.}

\item{use.harmonized.data}{A logical indicating whether the file should be formatted to indicate harmonized data columns for use in future PGS application.}
}
\value{
A list containing the file metadata and the weight data.
}
\description{
Import a PGS weight file formatted according to PGS catalog guidelines, and prepare for PGS application with \code{apply.polygenic.score()}.
}
\examples{
# Example pgs weight file
pgs.weight.path <- system.file(
    'extdata',
    'PGS000662_hmPOS_GRCh38.txt.gz',
    package = 'ApplyPolygenicScore',
    mustWork = TRUE
    );
import.pgs.weight.file(pgs.weight.path);

# Note, harmonized data is used by default. To disable set `use.harmonized.data = FALSE`
import.pgs.weight.file(pgs.weight.path, use.harmonized.data = FALSE);
}
